#include <vector>
#include <string>
#include <exception>
using namespace std;

#include "mathlink.h"
#include "ADExpressions/expression.h"

void PrintMLErrorMessage()
{
	char err_msg[100];
	sprintf(err_msg, "%s\"%.76s\"%s", "Message[MLCXSCErrorDdf::mlink,", MLErrorMessage(stdlink), "]");
	MLClearError(stdlink);
	MLNewPacket(stdlink);
	MLEvaluate(stdlink, err_msg);
	MLNextPacket(stdlink);
	MLNewPacket(stdlink);
	MLPutSymbol(stdlink, "$Failed");
}

void PrintErrorMessage(const mlcxsc::MLCXSCFunctionException& aException)
{
	char err_msg[1000];
	switch(aException.GetErrorCode())
	{
			case mlcxsc::MLCXSCFunctionException::ecIllegalArgumentError:
			{
				sprintf(err_msg, "%s\"%.76s\"%s", "Message[MLCXSCErrorDdf::illargs,", aException.what(), "]");
				break;
			}
			case mlcxsc::MLCXSCFunctionException::ecNotInitializedError:
			{
				sprintf(err_msg, "%s\"%.76s\"%s", "Message[MLCXSCErrorDdf::notrdy,", aException.what(), "]");
				break;
			}
			case mlcxsc::MLCXSCFunctionException::ecExpressionError:
			{
				sprintf(err_msg, "%s\"%.76s\"%s", "Message[MLCXSCErrorDdf::expr,", aException.what(), "]");
				break;
			}
			case mlcxsc::MLCXSCFunctionException::ecInternalError:
			{
				sprintf(err_msg, "%s\"%.76s\"%s", "Message[MLCXSCErrorDdf::internal,", aException.what(), "]");
				break;
			}
	}
	MLNewPacket(stdlink);
	MLEvaluate(stdlink, err_msg);
	MLNextPacket(stdlink);
	MLNewPacket(stdlink);
	MLPutSymbol(stdlink, "$Failed");
}

//************************ auxiliary functions *********************************

char* getVariable(void)
{
  char* var;
  switch(MLGetType(stdlink))
  {
    case MLTKSYM:
    {
      const char* name;
      MLGetSymbol(stdlink, &name);
      var = new char[strlen(name)+1];
      strcpy(var, name); 
      MLDisownSymbol(stdlink, name);
    }
    break;
    case MLTKFUNC:
    {  
      const char* name;
      long args;
      MLGetFunction(stdlink, &name, &args);
      bool success = false;
      if(args == 1)
      {
        if(MLGetType(stdlink) == MLTKINT)
        {
          int n;
          MLGetInteger(stdlink, &n);
          var = new char[strlen(name)+(int)std::floor(std::log10((double)std::abs(n!=0?n:1)))+5];
		 //  1 za num of digits, 1 za null, 2 za [], 1 za -
          sprintf(var, "%s[%d]", name, n);
          success = true;
          MLDisownSymbol(stdlink, name);
        }
      }
      if(!success)
      {
        MLDisownSymbol(stdlink, name);
        throw mlcxsc::MLCXSCFunctionException(mlcxsc::MLCXSCFunctionException::ecIllegalArgumentError, 
										std::string("Invalid variable name as first argument"));
      }
    }
    break;
    default:
    {
      throw mlcxsc::MLCXSCFunctionException(mlcxsc::MLCXSCFunctionException::ecIllegalArgumentError,
										std::string("Invalid variable name as first argument"));
    }
    break;
  }  
  return var;
}

//************************ function objects  ***********************************

mlcxsc::MLCXSCFunctionScalar<DerivType> scalarfunc_ddf;
         
DerivType sf_ddf(const DerivType& x)
{
        return scalarfunc_ddf(x);
}

//********************** initialization ****************************************

void InitScalarDdf()
{       try
	{
			scalarfunc_ddf.Init(getVariable()); 
			MLPutSymbol(stdlink, "Null");
	}
	catch(mlcxsc::MLCXSCFunctionException& e)
	{
		scalarfunc_ddf.Invalidate();
		PrintErrorMessage(e);
	}
}

//************************* evaluation *********************************************

void fValueScalarDdf()
{       try
        {
            long dim;
            double* ibounds;
            if(!MLGetRealList(stdlink, &ibounds, &dim))
            {
                PrintMLErrorMessage();
/*                char err_msg[100];
                sprintf(err_msg, "%s", MLErrorMessage(stdlink));
                MLClearError(stdlink);
                throw mlcxsc::MLCXSCFunctionException(mlcxsc::MLCXSCFunctionException::ecIllegalArgumentError, err_msg); */
                return; 
            }
            
            interval resf;
	    fEval(sf_ddf, interval(ibounds[0], ibounds[1]), resf);

// Initializing C variables that will pass the computed results back to Mathematica
                double res_data[2];
                res_data[0] = _double(Inf(resf));
                res_data[1] = _double(Sup(resf));
                MLPutRealList(stdlink, res_data, 2); // Send resf back to Mathematica                
        }
        catch(mlcxsc::MLCXSCFunctionException& e)
        {       PrintErrorMessage(e);       }
}

void dfValueScalarDdf()
{       try
        {  
            long dim;
            double* ibounds;
            if(!MLGetRealList(stdlink, &ibounds, &dim))
            {
                PrintMLErrorMessage();
                return;
            }

	    interval ival, resdf;
	    ival = interval(ibounds[0], ibounds[1]);
    	    DerivType fx;
    	    fx = scalarfunc_ddf(DerivVar(ival));
    	    resdf = dfValue(fx);

// Initializing C variables that will pass the computed results back to Mathematica
                double res_data[2];
                res_data[0] = _double(Inf(resdf));
                res_data[1] = _double(Sup(resdf));
                MLPutRealList(stdlink, res_data, 2); // Send df back to Mathematica            
        }
        catch(mlcxsc::MLCXSCFunctionException& e)
        {       PrintErrorMessage(e);       }  
}   

void ddfValueScalarDdf()
{       try
        {
            long dim;
            double* ibounds;
            if(!MLGetRealList(stdlink, &ibounds, &dim))
            {
                PrintMLErrorMessage();
                return;
            }
 
            interval ival, resddf;
	    ival = interval(ibounds[0], ibounds[1]);
            DerivType fx;
            fx = scalarfunc_ddf(DerivVar(ival));
            resddf = ddfValue(fx);

// Initializing C variables that will pass the computed results back to Mathematica  
                double res_data[2];
                res_data[0] = _double(Inf(resddf)); 
                res_data[1] = _double(Sup(resddf));
                MLPutRealList(stdlink, res_data, 2); // Send ddf back to Mathematica
        }
        catch(mlcxsc::MLCXSCFunctionException& e)
        {       PrintErrorMessage(e);       }
}


void dfEvalScalarDdf()
{       try
        {
            long dim;
            double* ibounds;
            if(!MLGetRealList(stdlink, &ibounds, &dim))
            {
                PrintMLErrorMessage();
                return;
            }
            
            interval resf, resdf;
            dfEval(sf_ddf, interval(ibounds[0], ibounds[1]), resf, resdf);

// Initializing C variables that will pass the computed results back to Mathematica
                MLPutFunction(stdlink, "List", 2); // return f, df
                double res_data[2];
                res_data[0] = _double(Inf(resf));
                res_data[1] = _double(Sup(resf));
                MLPutRealList(stdlink, res_data, 2); // Send f back to Mathematica
            
                res_data[0] = _double(Inf(resdf));
                res_data[1] = _double(Sup(resdf));
                MLPutRealList(stdlink, res_data, 2); // Send df back to Mathematica
        }
        catch(mlcxsc::MLCXSCFunctionException& e)
        {       PrintErrorMessage(e);       }
}


void CalcScalarDdf()
{       try
        {
            long dim;
            double* ibounds;
            if(!MLGetRealList(stdlink, &ibounds, &dim))
            {
                PrintMLErrorMessage();
                return;
            }
                
            interval resf, resdf, resddf;
            ddfEval(sf_ddf, interval(ibounds[0], ibounds[1]), resf, resdf, resddf);

// Initializing C variables that will pass the computed results back to Mathematica
                MLPutFunction(stdlink, "List", 3); // return f, df, ddf
                double res_data[2];
                res_data[0] = _double(Inf(resf));
                res_data[1] = _double(Sup(resf));
                MLPutRealList(stdlink, res_data, 2); // Send f back to Mathematica
                
                res_data[0] = _double(Inf(resdf));
                res_data[1] = _double(Sup(resdf));
                MLPutRealList(stdlink, res_data, 2); // Send df back to Mathematica
        
                res_data[0] = _double(Inf(resddf));
                res_data[1] = _double(Sup(resddf));
                MLPutRealList(stdlink, res_data, 2); // Send ddf back to Mathematica
        }
        catch(mlcxsc::MLCXSCFunctionException& e)
        {       PrintErrorMessage(e);       }
}


//****************** Function ReadyQ ******************************************************

void ReadyScalarDdfQ()
{
	if(scalarfunc_ddf.IsInitialized())
	{
		MLPutSymbol(stdlink, "True");
	}
	else
	{
		MLPutSymbol(stdlink, "False");
	}
}

//***************************** main *******************************************

int main(int argc, char* argv[]) // Standard MathLink main function
{
	return MLMain(argc, argv);
} 
