//-----------------------------------------------------------------------
// Embedding C-XSC module ddf_ari in Mathematica by MathLink communication
//-----------------------------------------------------------------------
//
// :Mathematica Version: 5.2 and above
// :Copyright: Evgenija Popova (IMI, BAS)
// :Name: ddfAri`
// :Title: C-XSC interval differentiation arithmetic for functions of one variable. 
//         It allows the evaluation of function and its derivatives up to second order.
// :Created:  February 2, 2010, see ddfAri.tm/cpp,  a package version
// :Modified: March 4, 2010: new exception messages.

:Evaluate: BeginPackage["ddfAri`"]

:Evaluate: SetFunction::usage = "SetFunction[varName, function] initializes a global variable with the functional expression 'function' of one variable 'varName'. The result is $Fail if there is some error in the initialization and Null otherwise."
:Evaluate: ReadyFunctionQ::usage = "ReadyFunctionQ[] checks whether a global variable storing the functional expression is initialized (and ready to be used) with a scalar function in one variable. It evaluates to False until SetFunction is called."
:Evaluate: fValue::usage = "fValue[interval] evaluates the scalar function, which has been initialized by the function SetFunction, in the interval 'interval' specified as a list of the interval end-points."
:Evaluate: dfValue::usage = "dfValue[interval] evaluates the first derivative of a scalar function, which has been initialized by the function SetFunction, in the interval 'interval' specified as a list of the interval end-points."
:Evaluate: ddfValue::usage = "ddfValue[interval] evaluates the second derivative of a scalar function, which has been initialized by the function SetFunction, in the interval 'interval' specified as a list of the interval end-points."
:Evaluate: dfEval::usage = "dfEval[varName, function, interval] evaluates a scalar function, specified by 'function', in one variable 'varName' and its first derivative, in the interval 'interval' specified as a list of the interval end-points."
:Evaluate: ddfEval::usage = "ddfEval[varName, function, interval] evaluates a scalar function, specified by 'function', in one variable 'varName' and its first and second derivatives, in the interval 'interval' specified as a list of the interval end-points."

:Evaluate: MLCXSCErrorDdf::usage = "The symbol MLCXSCErrorDdf is used to print the error messages that arrise during the initialization and the evaluation of functional expressions by the ddfAri package."

:Evaluate: Begin["ddfAri`Private`"]

:Evaluate:  MLCXSCErrorDdf::mlink = "Low-level MathLink error: `1`.";
:Evaluate:  MLCXSCErrorDdf::illargs = "Illegal arguments: `1`.";
:Evaluate:  MLCXSCErrorDdf::notrdy = "`1`.";
:Evaluate:  MLCXSCErrorDdf::expr = "Error in the expression: `1`.";
:Evaluate:  MLCXSCErrorDdf::internal = "Internal error: `1`.";

:Evaluate: msg = "The function is not initialized, use SetFunction to this end."

:Evaluate: fValue[val_List /; Length[val]===2] :=
        Block[{res}, res/; (res=fValueScalar[val]; res=!=$Failed)] /; ReadyFunctionQ[] ||(Message[MLCXSCErrorDdf::notrdy, msg]; False);

:Evaluate: dfValue[val_List /; Length[val]===2] :=                                                              
        Block[{res}, res/; (res=dfValueScalar[val]; res=!=$Failed)] /; ReadyFunctionQ[] ||(Message[MLCXSCErrorDdf::notrdy, msg]; False); 

:Evaluate: ddfValue[val_List /; Length[val]===2] :=                                                              
        Block[{res}, res/; (res=ddfValueScalar[val]; res=!=$Failed)] /; ReadyFunctionQ[] ||(Message[MLCXSCErrorDdf::notrdy, msg]; False); 

:Evaluate: dfEval[var_, func_, val_List /; Length[val]===2] :=
        Block[{res}, res /; (res=dfEvalScalar[val]; res=!=$Failed)] /; SetFunction[var, func]===Null;

:Evaluate: ddfEval[var_, func_, val_List /; Length[val]===2] :=                                                             
        Block[{res}, res /; (res=CalcScalarDdf[val]; res=!=$Failed)] /; SetFunction[var, func]===Null; 


:Begin:
:Function:       InitScalarDdf
:Pattern:        SetFunction[varname_, func_]
:Arguments:      { varname, func }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       fValueScalarDdf
:Pattern:        fValueScalar[val_]
:Arguments:      { val }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin: 
:Function:       dfValueScalarDdf
:Pattern:        dfValueScalar[val_]
:Arguments:      { val }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       ddfValueScalarDdf
:Pattern:        ddfValueScalar[val_]
:Arguments:      { val }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       dfEvalScalarDdf
:Pattern:        dfEvalScalar[val_]
:Arguments:      { val }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       CalcScalarDdf
:Pattern:        CalcScalarDdf[val_] 
:Arguments:      { val }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       ReadyScalarDdfQ
:Pattern:        ReadyFunctionQ[] 
:Arguments:      { }
:ArgumentTypes:  { }
:ReturnType:     Manual
:End:


:Evaluate: End[]

:Evaluate: EndPackage[]
