//-----------------------------------------------------------------------
// Embedding C-XSC module grad_ari in Mathematica by MathLink communication
//-----------------------------------------------------------------------
//
// :Mathematica Version: 5.2 and above						
// :Copyright: Evgenija Popova (IMI, BAS)						 	
// :Name: gradAri`
// :Title: C-XSC interval differentiation arithmetic which allows the evaluation of scalar or vector-valued functions
//	   with automatic differentiation up to first order (i.e. gradient or Jacobian matrix).
// :Created:  January 28, 2010, see gradAri.tm/cpp,  a package version
// :Modified: March 4, 2010: new exception messages.

:Evaluate: BeginPackage["gradAri`"]

:Evaluate: SetFScalarGrad::usage = "SetFScalarGrad[{varName1, ...}, function] initializes a global variable with the functional expression of 'function' in the variables specified by varName1, .... The result is $Failed if there is some error in the initialization, and Null otherwise."
:Evaluate: ReadyScalarGradQ::usage = "ReadyScalarGradQ[] checks whether the stack is initialized with a scalar function. It evaluates to False until SetFScalarGrad[] is executed successfully."
:Evaluate: fValueScalarG::usage = "fValueScalarG[{int1, int2, ...}] evaluates the scalar function, which has been initialized by the function SetFScalarGrad, in the intervals int1, int2, ... for the function variables."
:Evaluate: gradValueG::usage = "gradValueG[{int1, int2, ...}] evaluates the gradient of a scalar function, which has been initialized by the function SetFScalarGrad, in the intervals int1, int2, ... for the function variables."
:Evaluate: fgEvalG::usage = "fgEvalG[{varName1, ...}, function, {int1, ...}] evaluates a scalar function, specified by 'function' in the variables varName1 etc., and its gradient for given intervals int1, (specified as list of end-points) etc. for the variables."

:Evaluate: SetFVectorGrad::usage = "SetFVectorGrad[{varName1, ...}, {function1, ...}] initializes a global variable with the functional expressions of a multi-valued function, specified in the second argument, in the variables specified by varName1, .... The result is $Failed if there is some error in the initialization, and Null otherwise. The number of variables must be equalt to the number of functions."
:Evaluate: ReadyVectorGradQ::usage = "ReadyVectorGradQ[] checks whether the stack is initialized with a vector-valued function. It evaluates to False until SetFVectorGrad[] is executed successfully."
:Evaluate: fValueVectorG::usage = "fValueVectorG[{int1, int2, ...}] evaluates a vector-valued function, which has already been initialized by the function SetFVectorGrad, in the intervals int1, int2, ... for the function variables."
:Evaluate: JacValueG::usage = "JacValueG[{int1, int2, ...}] evaluates the Jacobian of a vector-valued function, which has already been initialized by the function SetFVectorGrad, in the intervals int1, int2, ... for the function variables."
:Evaluate: fJEvalJGrad::usage = "fJEvalJGrad[{varName1, ...}, {func1, ...}, {int1, ...}]  evaluates a vector-valued function, specified by {func1, ...} in the variables varName1 etc., and its Jacobian for given intervals int1, (specified as list of end-points) etc. for the variables. The three list arguments must have equal length."

:Evaluate: MLCXSCErrorGrad::usage = "The symbol MLCXSCErrorGrad is used to print the error messages that arrise during the initialization and the evaluations of functional expressions in the gradAri package."

:Evaluate: Begin["gradAri`Private`"]

:Evaluate:  MLCXSCErrorGrad::mlink = "Low-level MathLink error: `1`.";
:Evaluate:  MLCXSCErrorGrad::illargs = "Illegal arguments: `1`.";
:Evaluate:  MLCXSCErrorGrad::notrdy = "`1`.";
:Evaluate:  MLCXSCErrorGrad::expr = "Error in the expression: `1`.";
:Evaluate:  MLCXSCErrorGrad::internal = "Internal error: `1`.";

:Evaluate: msgScalarGrad = "The function is not initialized, use SetFScalarGrad to this end."

:Evaluate: fValueScalarG[vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
 	Block[{res}, res/; (res=fValueScalarGrad[vals]; res=!=$Failed)] /; 
	ReadyScalarGradQ[] || (Message[MLCXSCErrorGrad::notrdy, msgScalarGrad]; False);

:Evaluate: gradValueG[vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
        Block[{res}, res/; (res=gradValueScalar[vals]; res=!=$Failed)] /; 
	ReadyScalarGradQ[] || (Message[MLCXSCErrorGrad::notrdy, msgScalarGrad]; False);

:Evaluate: fgEvalG[varnames_, func_, vals:{__List}/; And@@(Length[#]==2&/@ vals)] := 
	Block[{res}, res /; (res=CalcScalarGrad[vals]; res=!=$Failed)] /; SetFScalarGrad[varnames, func]===Null;


:Evaluate: msgVectorGrad = "The function is not initialized, use SetFVectorGrad to this end."

:Evaluate: fValueVectorG[vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
        Block[{res}, res/; (res=fValueVectorGrad[vals]; res=!=$Failed)] /; 
	ReadyVectorGradQ[] || (Message[MLCXSCErrorGrad::notrdy, msgVectorGrad]; False);

:Evaluate: JacValueG[vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
        Block[{res}, res/; (res=JacValueGrad[vals]; res=!=$Failed)] /; 
	ReadyVectorGradQ[] || (Message[MLCXSCErrorGrad::notrdy, msgVectorGrad]; False);

:Evaluate:  fJEvalJGrad[varnames_, func_List, vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
                Block[{res}, res /; (res=CalcVectorGrad[vals]; res=!=$Failed)] /; SetFVectorGrad[varnames, func]===Null;


:Begin:
:Function:       SetFScalarGrad
:Pattern:        SetFScalarGrad[varnames_List /; Length[varnames]>0, func_]
:Arguments:      { varnames, func }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       SetFVectorGrad
:Pattern:        SetFVectorGrad[varnames_List /; Length[varnames]>0, func_]
:Arguments:      { varnames, func }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       fValueScalarGrad
:Pattern:        fValueScalarGrad[vals_]
:Arguments:      { vals }  
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       gradValueScalar
:Pattern:        gradValueScalar[vals_]
:Arguments:      { vals }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       CalcScalarGrad
:Pattern:        CalcScalarGrad[vals_] 
:Arguments:      { vals }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       fValueVectorGrad
:Pattern:        fValueVectorGrad[vals_]
:Arguments:      { vals }  
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       JacValueGrad
:Pattern:        JacValueGrad[vals_]
:Arguments:      { vals }  
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       CalcVectorGrad
:Pattern:        CalcVectorGrad[vals_] 
:Arguments:      { vals }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       ReadyScalarGradQ
:Pattern:        ReadyScalarGradQ[] 
:Arguments:      { }
:ArgumentTypes:  { }
:ReturnType:     Manual
:End:

:Begin:
:Function:       ReadyVectorGradQ
:Pattern:        ReadyVectorGradQ[] 
:Arguments:      { }
:ArgumentTypes:  { }
:ReturnType:     Manual
:End:

:Evaluate: End[]

:Evaluate: EndPackage[]

