//-----------------------------------------------------------------------
// Embedding C-XSC module hess_ari in Mathematica by MathLink communication
//-----------------------------------------------------------------------
//
// :Mathematica Version: 5.2 and above						
// :Copyright: Evgenija Popova (IMI, BAS)						 	
// :Name: hessAri`
// :Title: C-XSC interval differentiation arithmetic which allows the evaluation of scalar or vector-valued functions
//	   with automatic differentiation up to second order.
// :Created:  January 29, 2010, see hessAri.tm/cpp,  a package version
// :Modified: March 4, 2010: new exception messages.

:Evaluate: BeginPackage["hessAri`"]

:Evaluate: SetFScalarHess::usage = "SetFScalarHess[{varName1, ...}, function] initializes a global variable with the functional expression of 'function' in the variables specified by varName1, .... The result is $Failed if there is some error in the initialization, and Null otherwise."
:Evaluate: ReadyScalarHessQ::usage = "ReadyScalarHessQ[] checks whether the stack is initialized with a scalar function. It evaluates to False until SetFScalarHess[] is executed successfully."
:Evaluate: fValueScalarH::usage = "fValueScalarH[{int1, int2, ...}] evaluates the scalar function, which has been initialized by the function SetFScalarHess, in the intervals int1, int2, ... for the function variables."
:Evaluate: gradValueH::usage = "gradValueH[{int1, int2, ...}] evaluates the gradient of a scalar function, which has been initialized by the function SetFScalarHess, in the intervals int1, int2, ... for the function variables."
:Evaluate: hessValue::usage = "hessValue[{int1, int2, ...}] evaluates the hessian of a scalar function, which has been initialized by the function SetFScalarHess, in the intervals int1, int2, ... for the function variables."
:Evaluate: fgEvalH::usage = "fgEvalH[{varName1, ...}, function, {int1, ...}] evaluates a scalar function, specified by 'function' in the variables varName1 etc., and its gradient for given intervals int1, (specified as list of end-points) etc. for the variables."
:Evaluate: fghEvalH::usage = "fghEvalH[{varName1, ...}, function, {int1, ...}] evaluates a scalar function, specified by 'function' in the variables varName1 etc., its gradient and hessian for given intervals int1, (specified as list of end-points) etc. for the variables."

:Evaluate: SetFVectorHess::usage = "SetFVectorHess[{varName1, ...}, {function1, ...}] initializes a global variable with the functional expressions of a multi-valued function, specified in the second argument, in the variables specified by varName1, .... The result is $Failed if there is some error in the initialization, and Null otherwise. The number of variables must be equalt to the number of functions."
:Evaluate: ReadyVectorHessQ::usage = "ReadyVectorHessQ[] checks whether the stack is initialized with a vector-valued function. It evaluates to False until SetFVectorHess[] is executed successfully."
:Evaluate: fValueVectorH::usage = "fValueVectorH[{int1, int2, ...}] evaluates a vector-valued function, which has already been initialized by the function SetFVectorHess, in the intervals int1, int2, ... for the function variables."
:Evaluate: JacValueH::usage = "JacValueH[{int1, int2, ...}] evaluates the Jacobian of a vector-valued function, which has already been initialized by the function SetFVectorHess, in the intervals int1, int2, ... for the function variables."
:Evaluate: fJEvalJHess::usage = "fJEvalJHess[{varName1, ...}, {func1, ...}, {int1, ...}]  evaluates a vector-valued function, specified by {func1, ...} in the variables varName1 etc., and its Jacobian for given intervals int1, (specified as list of end-points) etc. for the variables."

:Evaluate: MLCXSCErrorHess::usage = "The symbol MLCXSCErrorHess is used to print the error messages that arrise during the initialization and the evaluations of functional expressions in the hessAri package."

:Evaluate: Begin["hessAri`Private`"]

:Evaluate:  MLCXSCErrorHess::mlink = "Low-level MathLink error: `1`.";
:Evaluate:  MLCXSCErrorHess::illargs = "Illegal arguments: `1`.";
:Evaluate:  MLCXSCErrorHess::notrdy = "`1`.";
:Evaluate:  MLCXSCErrorHess::expr = "Error in the expression: `1`.";
:Evaluate:  MLCXSCErrorHess::internal = "Internal error: `1`.";

:Evaluate: msgScalarHess = "The function is not initialized, use SetFScalarHess to this end."

:Evaluate: fValueScalarH[vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
 	Block[{res}, res/; (res=fValueScalarHess[vals]; res=!=$Failed)] /; 
	ReadyScalarHessQ[] || (Message[MLCXSCErrorHess::notrdy, msgScalarHess]; False);

:Evaluate: gradValueH[vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
        Block[{res}, res/; (res=gradValueScalarHess[vals]; res=!=$Failed)] /; 
	ReadyScalarHessQ[] || (Message[MLCXSCErrorHess::notrdy, msgScalarHess]; False);

:Evaluate: hessValue[vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
        Block[{res}, res/; (res=hessValueScalarHess[vals]; res=!=$Failed)] /; 
	ReadyScalarHessQ[] || (Message[MLCXSCErrorHess::notrdy, msgScalarHess]; False);

:Evaluate: fgEvalH[varnames_, func_, vals:{__List}/; And@@(Length[#]==2&/@ vals)] := 
	Block[{res}, res /; (res=fgEvalHess[vals]; res=!=$Failed)] /; SetFScalarHess[varnames, func]===Null;

:Evaluate: fghEvalH[varnames_, func_, vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
        Block[{res}, res /; (res=CalcScalarHess[vals]; res=!=$Failed)] /; SetFScalarHess[varnames, func]===Null;
        

:Evaluate: msgVectorHess = "The function is not initialized, use SetFVectorHess to this end."

:Evaluate: fValueVectorH[vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
        Block[{res}, res/; (res=fValueVectorHess[vals]; res=!=$Failed)] /; 
	ReadyVectorHessQ[] || (Message[MLCXSCErrorHess::notrdy, msgVectorHess]; False);

:Evaluate: JacValueH[vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
        Block[{res}, res/; (res=JacValueHess[vals]; res=!=$Failed)] /; 
	ReadyVectorHessQ[] || (Message[MLCXSCErrorHess::notrdy, msgVectorHess]; False);

:Evaluate:  fJEvalJHess[varnames_, func_List, vals:{__List}/; And@@(Length[#]==2&/@ vals)] :=
                Block[{res}, res /; (res=CalcVectorHess[vals]; res=!=$Failed)] /; SetFVectorHess[varnames, func]===Null;


:Begin:
:Function:       SetFScalarHess
:Pattern:        SetFScalarHess[varnames_List /; Length[varnames]>0, func_]
:Arguments:      { varnames, func }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       SetFVectorHess
:Pattern:        SetFVectorHess[varnames_List /; Length[varnames]>0, func_]
:Arguments:      { varnames, func }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       fValueScalarHess
:Pattern:        fValueScalarHess[vals_]
:Arguments:      { vals }  
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       gradValueScalarHess
:Pattern:        gradValueScalarHess[vals_]
:Arguments:      { vals }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       hessValueScalarHess
:Pattern:        hessValueScalarHess[vals_]
:Arguments:      { vals }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       fgEvalHess
:Pattern:        fgEvalHess[vals_]
:Arguments:      { vals }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       CalcScalarHess
:Pattern:        CalcScalarHess[vals_] 
:Arguments:      { vals }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       fValueVectorHess
:Pattern:        fValueVectorHess[vals_]
:Arguments:      { vals }  
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       JacValueHess
:Pattern:        JacValueHess[vals_]
:Arguments:      { vals }  
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       CalcVectorHess
:Pattern:        CalcVectorHess[vals_] 
:Arguments:      { vals }
:ArgumentTypes:  { Manual }
:ReturnType:     Manual
:End:

:Begin:
:Function:       ReadyScalarHessQ
:Pattern:        ReadyScalarHessQ[] 
:Arguments:      { }
:ArgumentTypes:  { }
:ReturnType:     Manual
:End:

:Begin:
:Function:       ReadyVectorHessQ
:Pattern:        ReadyVectorHessQ[] 
:Arguments:      { }
:ArgumentTypes:  { }
:ReturnType:     Manual
:End:

:Evaluate: End[]

:Evaluate: EndPackage[]

