#include <cstdio>
#include <vector>
#include <algorithm>
#include <cassert>
#include <cstring>

const int MAXN = 1 << 10;

struct el {
	int to;
	int dist;
	int next;
	el () {}
	el (int _to, int _dist, int _next) : to (_to), dist (_dist), next (_next) {}
};

int N;
int vec[MAXN];
el buf[MAXN * 2];

int _ans;

void bfs (int s) {
	static int q[MAXN];
	static int d[MAXN];
	static int used[MAXN];
	static int p3;
	int u = s + 1;

	used[s] = u;
	d[s] = 0;
	q[p3 = 0, p3++] = s;
	int c;
	for (int i = 0; i < p3; ++i) {
		c = q[i];
		assert (c >= 0 && c < N);
		if (_ans < d[c])
			_ans = d[c];

		for (int j = vec[c]; j != -1; j = buf[j].next) {
			if (used[buf[j].to] != u) {
				used[buf[j].to] = u;
				d[buf[j].to] = d[c] + buf[j].dist;
				q[p3++] = buf[j].to;
			}
		}
	}
}

int main () {
	scanf ("%d", &N);

	int i;
	int a, b, d;
	int bp = 0;
	memset (vec, -1, sizeof (vec));
	for (i = 1; i < N; ++i) {
		scanf ("%d %d %d", &a, &b, &d);
		--a; --b;
		assert (a < N && b < N && a >= 0 && b >= 0);

		buf[bp] = el (b, d, vec[a]);
		vec[a] = bp++;

		buf[bp] = el (a, d, vec[b]);
		vec[b] = bp++;
	}

	for (i = 0; i < N; ++i)
		bfs (i);

	printf ("%d\n", _ans);

	return 0;
}
