#include<cstdio>
#include<cstdlib>
#include<cmath>

const int MAXVAL=999999999;
int n,k;
int x[2000], y[2000];
int b[100],p[100];
int minar=MAXVAL;
const double eps=1e-6;
const double TwoPi=2.0*M_PI;
double ap[100][100][100];

int cross(int i0, int i1, int i2)
{
 int dx1=x[i1]-x[i0]; int dy1=y[i1]-y[i0];
 int dx2=x[i2]-x[i0]; int dy2=y[i2]-y[i0];
 return dx1*dy2-dy1*dx2;
}

double angc(int i0, int i1, int i2)
{
 int dx1=x[i1]-x[i0]; int dy1=y[i1]-y[i0];
 int dx2=x[i2]-x[i1]; int dy2=y[i2]-y[i1];


 int sp=dx1*dx2+dy1*dy2;
 int len1=dx1*dx1+dy1*dy1;
 int len2=dx2*dx2+dy2*dy2;
 double v=(double)(sp)/sqrt((double)(len1)*(len2));
 return acos(v);
}



double ang(int i0, int i1, int i2)
{

 return ap[i0][i1][i2];
/*
 int dx1=x[i1]-x[i0]; int dy1=y[i1]-y[i0];
 int dx2=x[i2]-x[i1]; int dy2=y[i2]-y[i1];


 int sp=dx1*dx2+dy1*dy2;
 int len1=dx1*dx1+dy1*dy1;
 int len2=dx2*dx2+dy2*dy2;
 double v=(double)(sp)/sqrt((double)(len1)*(len2));
 return acos(v);
*/
 
}


void go(int L, int a, double sa)
{
 if(a>minar)return;
 if(sa>TwoPi+eps) return;
 if(L==k+1)
 {
  if(cross(p[k],p[1],p[2])<0) return;
  double av=ang(p[k-1],p[k],p[1])+ang(p[k],p[1],p[2]);
  if(sa+av>TwoPi+eps)return;
  if(a<minar)
  {
   minar=a;
   return;
  }
 }

 for(int i=p[1]+1; i<=n; i++)
 if(b[i]==0)
 if(cross(p[L-2], p[L-1],i)>0)
 {
   int v=cross(p[1],p[L-1],i);
   if(v>0)
    {
      double av=ang(p[L-2],p[L-1],i);
      b[i]=1; p[L]=i;
      go(L+1, a+v, sa+av);
      b[i]=0;
    }
 }
}


void search()
{
 for(int i1=1;i1<=n-k+1;i1++)
 { b[i1]=1; p[1]=i1;
   for(int i2=i1+1;i2<=n;i2++)
   { b[i2]=1; p[2]=i2;
     for(int i3=i1+1;i3<=n;i3++)
     if(b[i3]==0)
     { b[i3]=1; p[3]=i3;
       int v=cross(i1,i2,i3);
       if(v>0)
       {
        double av=ang(i1,i2,i3);
        go(4,v,av);
       }
       b[i3]=0;
     }
     b[i2]=0;
   }
   b[i1]=0;
 }
}

void preproc()
{
 for(int i1=1;i1<=n;i1++)
 for(int i2=1;i2<=n;i2++)
 for(int i3=1;i3<=n;i3++)
 ap[i1][i2][i3]=angc(i1,i2,i3);

}


int main()
{
  
  scanf("%d%d",&n,&k);
  for(int i=1;i<=n;i++)
   {int x0, y0; scanf("%d%d",&x0,&y0); x[i]=2*x0; y[i]=2*y0;}

  preproc();
  search();
  
  if(minar==MAXVAL)minar=0;
  printf("%d\n",minar/8);
  

}


