#include <cstdio>
#include <climits>
#include <cstring>
#include <cstdlib>

#include <algorithm>
#include <ext/hash_map>

const int MAXN = 1 << 6;

namespace std {
	using namespace __gnu_cxx;
};

struct pnt {
	int x, y;
	pnt () {}
	pnt (int _x, int _y) : x (_x), y (_y) {}

	pnt operator + (const pnt &a) const {return pnt (x + a.x, y + a.y);}
	pnt operator - (const pnt &a) const {return pnt (x - a.x, y - a.y);}

	bool operator < (const pnt &a) const {return x != a.x ? x < a.x : y < a.y;}
};

int S (const pnt &a, const pnt &b, const pnt &c) {
	return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
}

int N, K;
pnt vec[MAXN];

struct part {
	int p1, p2;
	int q1, q2;

	part (int _common, int _up, int _down)
	: p1 (_common), p2 (_up), q1 (_common), q2 (_down) {}

	part (int _p1, int _p2, int _q1, int _q2)
	: p1 (_p1), p2 (_p2), q1 (_q1), q2 (_q2) {}

	bool operator == (const part &a) const {
		return memcmp (this, &a, sizeof (part)) == 0;
	}

	bool can_put (int p) const {
		return S (vec[p1], vec[p2], vec[p]) < 0
			&& S (vec[q1], vec[q2], vec[p]) > 0
			&& S (vec[q2], vec[p], vec[p2]) > 0;
	}

	part put_up (int np) const {
		return part (p2, np, q1, q2);
	}

	part put_down (int np) const {
		return part (p1, p2, q2, np);
	}
};

namespace __gnu_cxx {
	template <>
	struct hash <part> {
		size_t operator () (const part &a) const {
			return a.p1 << 18 | a.p2 << 12 | a.q1 << 6 | a.q2 << 0;
		}
	};
}

std::hash_map <part, int> _dp1, _dp2;
std::hash_map <part, int> *old_dp = &_dp1, *new_dp = &_dp2;

void upd (std::hash_map <part, int> *dp, const part &p, int s) {
	std::pair <std::hash_map <part, int> :: iterator, bool> xx = dp->insert (std::make_pair (p, s));
	if (xx.second == false)
		if (xx.first->second > s)
			xx.first->second = s;
}

int main () {
	scanf ("%d %d", &N, &K);

	if (K < 3) {
		puts ("0");
		return 0;
	}

	int i;
	for (i = 0; i < N; ++i)
		scanf ("%d %d", &vec[i].x, &vec[i].y);

	std::sort (vec, vec + N);

	int i1, i2, i3;
	for (i1 = 0; i1 < N; ++i1)
		for (i2 = i1+1; i2 < N; ++i2)
			for (i3 = i2+1; i3 < N; ++i3)
				if (S (vec[i1], vec[i2], vec[i3]) > 0)
					old_dp->operator[] (part (i1, i3, i2)) = abs (S (vec[i1], vec[i2], vec[i3]));
				else
					old_dp->operator[] (part (i1, i2, i3)) = abs (S (vec[i1], vec[i2], vec[i3]));

/*
	for (int i = 0; i < N; ++i)
		printf ("%d -- %d %d\n", i, vec[i].x, vec[i].y);
*/
/*
	for (std::hash_map <part, int> ::iterator it = old_dp->begin (); it != old_dp->end (); ++it)
		printf ("in dp [3] %d %d %d %d -- %d\n", it->first.p1, it->first.p2, it->first.q1, it->first.q2, it->second);
*/

	int k;
	for (k = 3; k < K; ++k) {
		new_dp->clear ();
		for (std::hash_map <part, int> ::iterator it = old_dp->begin (); it != old_dp->end (); ++it) {
//			printf ("in dp [%d] %d %d %d %d -- %d\n", k, it->first.p1, it->first.p2, it->first.q1, it->first.q2, it->second);
			for (i = 0; i < N; ++i)
				if (it->first.can_put (i)) {
					upd (new_dp, it->first.put_up   (i), it->second + abs (S (vec[it->first.p2], vec[i], vec[it->first.q2])));
					upd (new_dp, it->first.put_down (i), it->second + abs (S (vec[it->first.q2], vec[i], vec[it->first.p2])));
				}
		}
		std::swap (old_dp, new_dp);
	}
/*
	puts ("");
	for (std::hash_map <part, int> ::iterator it = old_dp->begin (); it != old_dp->end (); ++it)
		printf ("in dp [%d] %d %d %d %d -- %d\n", K, it->first.p1, it->first.p2, it->first.q1, it->first.q2, it->second);
*/
	int ans = INT_MAX;
	for (std::hash_map <part, int> :: iterator it = old_dp->begin (); it != old_dp->end (); ++it) {
//		printf (" %d", it->second);
		if (ans > it->second)
			ans = it->second;
	}
//	puts ("");

	printf ("%d\n", ans == INT_MAX ? 0 : ans / 2);

	return 0;
}
