#include <stdio.h>
#include <string.h>

#define MAXN 1024

int N;
int coords[MAXN*MAXN][2]; /* coords[i] are coordinates of doll of size i */
int tree[MAXN][MAXN];

void update1(int x, int y, int val)
{
	while (y<=MAXN)
	{
		if(val>tree[x][y])
			tree[x][y]=val;
		y+=(y & -y);
	}
}

void update(int x, int y, int val)
{
	while (x<=MAXN)
	{
		update1(x, y, val);
		x+=(x & -x);
	}
}

int query1(int x, int y)
{
	static int res;
	for(res=0; y>0; y-=(y & -y))
		if(tree[x][y]>res)
			res=tree[x][y];
	return res;
}

int query(int x, int y)
{
	static int res, tmp;
	for(res=0; x>0; x-=(x & -x))
	{
		tmp=query1(x, y);
		if(tmp>res)
			res=tmp;
	}
	return res;
}

void input(void)
{
	int x, y, Mxy;
	scanf("%d", &N);
	for(x=0; x<N; ++x)
	{
		for(y=0; y<N; ++y)
		{
			scanf("%d", &Mxy);
			coords[Mxy-1][0]=x+1;
			coords[Mxy-1][1]=y+1;
		}
	}
}

int calc(void)
{
	int i, curr;
	int best=0; /* will store the longest path found so far */
	for(i=0; i<N*N; ++i)
	{
		curr=query(coords[i][0], coords[i][1])+1; /* find the maximum */
		if(curr>best) /* update the longest path */
		{
			best=curr;
		}
		update(coords[i][0], coords[i][1], curr);	/* add the current path to 
																	the tree */
	}
	return best;
}

int main(void)
{
	memset(tree, 0, sizeof tree); 
	input();
	printf("%d\n", calc());
	return 0;
}
