#include <cstdio>
#include <utility>

const int MAXN = 1 << 10;

int N;
int idt[MAXN][MAXN];

int NN;
std::pair <int, int> order[MAXN * MAXN];

void add (int x, int y, int val) {
//	printf ("add %d %d  %d\n", x, y, val);
	for (int i = x; i <= N; i += i & -i)
		for (int j = y; j <= N; j += j & -j)
			if (idt[i][j] < val)
				idt[i][j] = val;
}

int srch (int x, int y) {
	static int res;
	res = 0;
	for (int i = x; i; i &= i - 1)
		for (int j = y; j; j &= j - 1)
			if (res < idt[i][j])
				res = idt[i][j];
//	printf ("srch %d %d --> %d\n", x, y, res);
	return res;
}

int main () {
	scanf ("%d", &N);
	NN = N * N;

	for (int i = 1; i <= N; ++i)
		for (int j = 1; j <= N; ++j) {
			int pos;
			scanf ("%d", &pos);
			order[pos-1] = std::make_pair (i, j);
		}

	for (int i = 0; i < NN; ++i)
		add (order[i].first, order[i].second, srch (order[i].first, order[i].second) + 1);

	printf ("%d\n", srch (N, N));

	return 0;
}
