#include <stdlib.h>
#include <stdio.h>

#define MAXN 1024

int N, seed;
int M[MAXN][MAXN];

void generateTable(void)
{
	int x, y, i, j, t;
	
	for(x=i=0; x<N; ++x)
	{
		for(y=0; y<N; ++y)
		{
			M[x][y]=++i;
		}
	}
			
	for(x=0; x<N; ++x)
	{
		for(y=0; y<N; ++y)
		{
			i=rand()%N;
			j=rand()%N;
			t=M[i][j];
			M[i][j]=M[x][y];
			M[x][y]=t;
		}
	}
}

void outputTable(void)
{
	int x, y;
	printf("%d\n", N);
	for(x=0; x<N; ++x)
	{
		for(y=0; y<N-1; ++y)
		{
			printf("%d ", M[x][y]);
		}
		printf("%d\n", M[x][y]);
	}
}

int main(int argc, char **argv)
{
	int i;
	if(argc!=3)
	{
		printf("Wrong arguments. Usage: <N> <seed>\n");
		return -1;
	}
	N=atoi(argv[1]);
	seed=atoi(argv[2]);
	srand(seed);
	generateTable();
	outputTable();
	return 0;
}
