#include <iostream>

using namespace std;

int const MAXN = 50010;

bool sieve[MAXN];
long a[MAXN];
long s[MAXN];
long cnt;

int eratosthenes(long n)
{ for(long i = 2; i <= n; i++)
    if (!sieve[i])
      { a[cnt] = i; 
        cnt++;
        for(long j = i+i; j <= n; j+= i)
          sieve[j] = true;
      }
  if (a[cnt-1] == n) return 1;
  return 0;
}

int main()
{  long n;
   cin >> n;
   if (n == 1)
     { cout << 0 << endl;
       return 0;
     }
   
   int is_n_prime;
   is_n_prime = eratosthenes(n);
   long p = n+1;
   bool is_p_prime;
   do
     { is_p_prime = true;
       long i = 0;
       while(is_p_prime && a[i]*a[i] <= p)
         { if (p%a[i] == 0)
             {is_p_prime = false; 
              p++;
             }
           i++;
         }  
       }
   while(!is_p_prime);
   
   s[0] = 1;
   for(long k = 0; k < cnt; k++)
     { long x = a[k];
       for(long i = x; i <= n; i++)
         s[i] = (s[i]+s[i-x])%p;
     }   
  
   s[n] = (s[n]+p-is_n_prime)%p; 
   cout << s[n] << endl;
   
   return 0;
}
     
            
