#include <stdio.h>

#define MAXN 256
// N^2 will time limit on larger inputs, so we don't need more memory

int N;
int M[MAXN][MAXN]; /* m[i][j] is the size of the doll in room (i, j) */
short f[MAXN][MAXN]; /* f[i][j] shows the longest path wich ends in room (i, j) */

void input(void)
{
	int x, y;
	
	scanf("%d", &N);
	for(x=0; x<N; ++x)
	{
		for(y=0; y<N; ++y)
		{
			scanf("%d", &M[x][y]);
		}
	}
}

int calcF(void)
{
	int i, j, k, l;
	int maxVal=1; /* Here we will store the longest path found so far */
	
	for(i=0; i<N; ++i)
	{
		for(j=0; j<N; ++j)
		{
			f[i][j]=0; 
			for(k=0; k<=i; ++k)
			{
				for(l=0; l<=j; ++l)
				{
					if(f[k][l]>f[i][j] && M[k][l]<M[i][j] && (k!=i || l!=j))
					{
						f[i][j]=f[k][l];
					}
				}
			}
			f[i][j]++; /* f[i][j]=1+max{f[k][l]} */
			if(f[i][j]>maxVal)
			{
				maxVal=f[i][j];
			}
		}
	}
	
	return maxVal;
}

int main(void)
{
	input();
	printf("%d\n", calcF());
	return 0;
}
